<?php

declare(strict_types=1);

/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2014-2018 Spomky-Labs
 *
 * This software may be modified and distributed under the terms
 * of the MIT license.  See the LICENSE file for details.
 */

namespace Jose\Bundle\JoseFramework\DependencyInjection\Source\Console;

use Jose\Bundle\JoseFramework\DependencyInjection\Source\Source;
use Jose\Component\Console\EcKeyGeneratorCommand;
use Symfony\Component\Config\Definition\Builder\NodeDefinition;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Loader\YamlFileLoader;

class ConsoleSource implements Source
{
    public function name(): string
    {
        return 'console';
    }

    public function load(array $configs, ContainerBuilder $container)
    {
        if (!$this->isEnabled()) {
            return;
        }
        $loader = new YamlFileLoader($container, new FileLocator(__DIR__.'/../../../Resources/config'));
        $loader->load('commands.yml');
    }

    public function getNodeDefinition(NodeDefinition $node)
    {
    }

    public function prepend(ContainerBuilder $container, array $config): array
    {
        return [];
    }

    private function isEnabled(): bool
    {
        return \class_exists(EcKeyGeneratorCommand::class);
    }
}
